/* $Header: TestNTriple2NDM.java 13-mar-2006.09:12:48 alwu Exp $ */

/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    alwu        03/13/06 - A bit cleanup and merge description from MAIN 
    nalexand    09/19/05 - batch testing 
    nalexand    09/14/05 - batch updating 
    nalexand    08/03/05 - loadtest
    nalexand    07/25/05 - change package: rdf.client 
    nalexand    07/13/05 - loadtest -- indexes 
    nalexand    06/22/05 - loadtest
    nalexand    06/21/05 - long literal load test 
    nalexand    05/22/05 - testing ntriple input 
    nalexand    05/12/05 - reif testing 
    nalexand    04/15/05 - testing long literals 
    nalexand    03/22/05 - clob test 
    nalexand    03/17/05 - update to handle type changes 
    nalexand    01/27/05 - add faster load option 
    nalexand    01/17/05 - testing
    nalexand    11/22/04 - testing in different databases
    nalexand    11/04/04 - nalexand_rdfjava0311
    nalexand    11/03/04 - Creation
 */

/**
 *  @version $Header: TestNTriple2NDM.java 13-mar-2006.09:12:48 alwu Exp $
 *  @author  nalexand
 *  @since   release specific (what release of product did this appear in)
 */
 
package oracle.spatial.rdf.client;
 
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;


/**
 * DESCRIPTION
 *  This class provides an example of how to convert RDF data in N-Triple format to 
 *  Oracle's RDF storage type, SDO_RDF_TRIPLE_S in Oracle10g R2.

 * NOTES
 *  In order to use the TestNTriple2NDM example and/or the Java-based NTripleConverter 
 *      the following requirements must be met:
 *  1) Must have an Oracle10g R2 database with Spatial installed
 *  2) Must have a user/password account for the database with connect and 
 *     resource privileges
 *  3) Must have an RDF network created in the database
 *  4) Must have an RDF table with at least the columns 
 *     (id NUMBER, triple SDO_RDF_TRIPLE_S); and an RDF model 
 *     associated with the table.
 *  5) Must be using the following supplied Oracle10g R2 utilities and 
 *     JDBC libraries (JARs): ojdbc14.jar and sdordf.jar
 *  6) Must have installed the Sun JDK version 1.4.2_04 or higher
 *  7) Must have an N-Triple file with no NULL fields. NULLs or empty strings 
 *     are NOT supported by Oracle's RDF data type.
 **/
public class TestNTriple2NDM 
{
  public TestNTriple2NDM()
  {
  }

  protected static OracleConnection m_conn;

  // some default values 
  private static String ms_szUser = "scott";
  private static String ms_szPass = "tiger";
  private static String ms_szHost = "127.0.0.1";
  private static String ms_szSid  = "orcl";
  private static String ms_szPort = "1521";

  static
  { 
    // database connection for testing using scott/tiger
    OracleConnection conn = null;

    String szVal = null;
    if ((szVal = System.getProperty("db.user")) != null) {
      ms_szUser = szVal;
    }

    if ((szVal = System.getProperty("db.password")) != null) {
      ms_szPass = szVal;
    }

    if ((szVal = System.getProperty("db.host")) != null) {
      ms_szHost = szVal;
    }

    if ((szVal = System.getProperty("db.sid")) != null) {
      ms_szSid = szVal;
    }

    if ((szVal = System.getProperty("db.port")) != null) {
      ms_szPort = szVal;
    }
    
    try { 
      DriverManager.registerDriver(new OracleDriver()) ;
      
      String szJdbcConn = "jdbc:oracle:thin:@" + ms_szHost + ":" +
          ms_szPort + ":" + ms_szSid;

      System.out.println( "Note: You can use JVM properties -Ddb.user=<user> "
                        + "-Ddb.password=<password> "
                        + "-Ddb.host=<host> -Ddb.sid=<sid> -Ddb.port=<port> to "
                        + "configure database connection.");

      System.out.println("");

      System.out.println("Connecting to " + szJdbcConn + " as user " + 
          ms_szUser);
      System.out.flush();

      conn = (OracleConnection)DriverManager.getConnection(
          szJdbcConn, ms_szUser, ms_szPass); 
    } 
    catch(SQLException e) { 
      e.printStackTrace();
    }

    m_conn = conn;
  }


  /**
   * @param args
   */
  public static void main(String[] args)
    throws SQLException, FileNotFoundException, IOException
  {
    TestNTriple2NDM testNTriple2NDM = new TestNTriple2NDM();

    try{
      NTripleConverter.setConnection(m_conn);

      if (args.length == 3) {
        System.out.println("Do not reuse blank nodes");

        String filename = args [0];
        String tableName = args [1];
        String modelName = args [2];
        NTripleConverter.nTriple2NDM(filename,tableName,modelName);
      }

      else if (args.length == 4) {
        System.out.println("Reuse blank nodes");

        String filename = args [0];
        String tableName = args [1];
        String modelName = args [2];
        int modelID = Integer.parseInt(args[3]); 
        NTripleConverter.nTriple2NDM(filename,tableName,modelName,modelID);
      } 
      else {
        System.err.println( "\nUsage " 
                  + "\n   java -Ddb.user=<user>  -Ddb.password=<password> "
                  + "-Ddb.host=<host> -Ddb.sid=<sid> -Ddb.port=<port>  "
                  + testNTriple2NDM.getClass().getName() 
                  + " <NTripleFilename> <tablename> "
                  + " <modelName> [model_ID_forBlankNodeReuse] \n");
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
